/* ---------- js/popup-script.js ---------- */
const $ = (sel) => document.querySelector(sel);

/* Helper kirim pesan ke background aman */
async function safeSendMessage(data) {
  try {
    const response = await chrome.runtime.sendMessage(data);
    console.log('[POPUP] Respon:', response);
    return response;
  } catch (err) {
    console.warn('[POPUP] Gagal kirim pesan ke background, coba ulang...', err);
    // coba ulang 1x setelah 500ms
    await new Promise((r) => setTimeout(r, 500));
    try {
      const retry = await chrome.runtime.sendMessage(data);
      console.log('[POPUP] Respon retry:', retry);
      return retry;
    } catch (err2) {
      console.error('[POPUP] Gagal total kirim pesan ke background:', err2);
      alert('Gagal menghubungi background script. Silakan reload ekstensi.');
      return null;
    }
  }
}

document.addEventListener('DOMContentLoaded', async () => {
  console.log('[POPUP] DOM ready');

  const selDur = $('#videoDuration');
  if (selDur) {
    selDur.innerHTML = '';
    for (let i = 1; i <= 30; i++) {
      const opt = document.createElement('option');
      opt.value = i;
      opt.textContent = `${i} menit`;
      if (i === 1) opt.selected = true;
      selDur.appendChild(opt);
    }
  }

  $('#StartApps')?.addEventListener('click', async () => {
    const judul = $('#videoTitle')?.value.trim();
    const menit = parseInt($('#videoDuration')?.value, 10);

    if (!judul) return alert('Judul video masih kosong');
    if (!menit || menit < 1 || menit > 30) return alert('Pilih durasi 1–30 menit');

    console.log('[POPUP] Kirim pesan startApp:', judul, menit);

    const result = await safeSendMessage({ message: 'startApp', judul, menit });
    if (result) {
      console.log('[POPUP] startApp OK, tutup popup');
      window.close();
    } else {
      console.warn('[POPUP] startApp gagal / tidak ada respon');
    }
  });
});
