console.log('[FG] foreground.js loaded');

let processing = false;
let targetId = null;
let targetJudul = '';
let targetMenit = 1;
let userEmail = '';
let port = null;
let pingTimer = null;

// ====================
// KEEP ALIVE PORT
// ====================
function startKeepAlive() {
  if (pingTimer) clearInterval(pingTimer);
  try {
    port = chrome.runtime.connect({ name: 'keepAlive' });
    pingTimer = setInterval(() => {
      try { port?.postMessage({ t: Date.now() }); }
      catch { clearInterval(pingTimer); reconnectKeepAlive(); }
    }, 20000);

    port.onDisconnect.addListener(() => { clearInterval(pingTimer); reconnectKeepAlive(); });
  } catch { reconnectKeepAlive(); }
}
function reconnectKeepAlive() { setTimeout(startKeepAlive, 5000); }
startKeepAlive();

// ====================
// HELPERS
// ====================
const sleep = ms => new Promise(r => setTimeout(r, ms));
const getValidDurasiMenit = m => { const d = parseInt(m); return isNaN(d) || d <= 0 ? 1 : d; }

async function getUserEmail() {
  if (!chrome?.runtime?.sendMessage) return 'guest@chrome';
  return new Promise(resolve => {
    try {
      chrome.runtime.sendMessage({ action: 'getUserEmail' }, res => resolve(res?.email || 'guest@chrome'));
      setTimeout(() => resolve('guest@chrome'), 2500);
    } catch { resolve('guest@chrome'); }
  });
}

async function safeSendMessage(msg, retries = 3, delayMs = 800) {
  for (let i = 0; i < retries; i++) {
    try { const res = await new Promise(resolve => chrome.runtime.sendMessage(msg, r => resolve(r || null))); if (res !== null) return res; } catch {}
    await sleep(delayMs);
  }
  return null;
}

// ====================
// LOAD VIDEO
// ====================



// ====== fungsi utama ambil data video ======
async function loadVideoFromAPI(userEmail) {
  if (!userEmail || userEmail.trim() === '') {
    userEmail = 'vinetcs@gmail.com';
  }

  try {
    const res = await fetch('https://bangnopi.id/api_youtube/getvideoplay', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ email: userEmail }),
      cache: 'no-cache'
    });

    if (!res.ok) throw new Error('Network response not OK');
    const data = await res.json();

    if (!data || data.status === 'empty') {
      console.warn('Data kosong dari API');
      return false;
    }

    // ====== Simpan data ke variabel global ======
    targetId         = data.id;
    targetTanggal    = data.tanggal;
    targetChannel    = data.channel;
    targetJudul      = data.judul;
    targetDurasi     = data.durasi;
    targetStatus     = data.status;
    targetEmail      = data.email;
    targetViews      = data.views;
    targetCoin       = data.cost_coin || data.coin || 0;
    targetIdChannel  = data.id_channel;
    targetThumb      = data.thumbnails;
    targetIdVideo    = data.id_video;
    targetMenit      = getValidDurasiMenit(data.durasi);



    // ====== Update elemen panel (kalau ada) ======
    const vidTitleEl   = document.querySelector('#vidTitle');
    const vidDurationEl = document.querySelector('#vidDuration');
    const thumb         = document.querySelector('#previewThumb');
   
    if (vidTitleEl) vidTitleEl.textContent = targetJudul || '(judul tidak tersedia)';
    if (vidDurationEl) vidDurationEl.textContent = targetMenit;
     
    if (thumb) {
      thumb.innerHTML = `
        <img class="attachment-img"
             src="https://img.youtube.com/vi/${targetIdVideo}/default.jpg"
             style="width:180px;height:120px;border-radius:8px;">
      `;
    }
    
    console.log('[OK] Video data dari API:', data);
    return true;

  } catch (err) {
    console.error('Gagal load video dari API:', err);
    return false;
  }
}

// ====================
// UPDATE STATUS & VIEWS
// ====================
async function updateStatusVideo() {
  if (!targetId) return;
  try { 
    
	await fetch('https://bangnopi.id/campaign/getUpdateStatusVideo', { 
		method: 'POST', 
		body: new URLSearchParams({ id: targetId, email: userEmail }) 
	}); 
	
  } catch {}
}

async function updateViews() {
  if (!targetId || !userEmail) return;
  try {
    await fetch('https://bangnopi.id/campaign/getUpdateViews', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ id: targetId, email: userEmail })
    });
  } catch {}
}

// ====================
// AUTO RUN LOOP
// ====================
async function autoRunVideoLoop() {
  if (processing) return;
  processing = true;
  if (!userEmail) userEmail = await getUserEmail();
  const hasData = await loadVideoFromAPI(userEmail);
  if (!hasData) { processing = false; return setTimeout(autoRunVideoLoop, 5000); }

  try { await runFlow(targetJudul, targetMenit); await updateStatusVideo(); await updateViews(); }
  catch { }
  finally { processing = false; setTimeout(autoRunVideoLoop, 5000); }
}
autoRunVideoLoop();

// ====================
// MESSAGE LISTENER
// ====================
chrome.runtime.onMessage.addListener((req, sender, sendResponse) => {
  if (req?.message === 'startApp') {
    targetJudul = req.judul || targetJudul;
    targetMenit = getValidDurasiMenit(req.menit || targetMenit);
    if (!processing) autoRunVideoLoop();
    sendResponse(true);
    return true;
  }
});








/* ======================================
   MAIN FLOW = cari -> highlight -> klik
   -> tonton -> scroll random 2-3x
   ====================================== */
async function runFlow(judul, menit) {
  console.log('[FG] runFlow start', judul, menit);

  // 1) pastikan berada di halaman hasil pencarian
  if (location.pathname === '/' || location.pathname === '/feed' || location.pathname === '/results' && !document.querySelector('ytd-searchbox')) {
    const input = document.querySelector('input[name="search_query"]');
    if (input) {
      await typeAndSearch(input, judul);
    } else {
      location.href = `https://www.youtube.com/results?search_query=${encodeURIComponent(judul)}`;
      await waitForPath('/results');
    }
  } else if (!location.pathname.includes('/results')) {
    location.href = `https://www.youtube.com/results?search_query=${encodeURIComponent(judul)}`;
    await waitForPath('/results');
  }

  // 2) cari video
  const foundEl = await findVideoInResults(judul, 15, 800);
  if (!foundEl) {
    //console.warn('[FG] Video tidak ditemukan, lewati..., dan update status nya jadi Finish');
	 
      //console.log(`[FG] Status video ID ${targetId} diupdate ke "finish"`);
    location.href = 'https://www.youtube.com/';
    await waitForPath('/');
    return false; // skip supaya loop lanjut
  }

  // 3) highlight & klik
  foundEl.style.border = '3px solid limegreen';
  foundEl.scrollIntoView({ behavior: 'smooth', block: 'center' });
  await sleep(1000);
  try {
    foundEl.click();
  } catch (e) {
    const href = foundEl.href || foundEl.getAttribute('href');
    if (href) location.href = href;
  }

  // 4) tunggu halaman video terbuka
  await waitForPath('/watch');
  await sleep(2000);

  // 5) pastikan video siap
  const vid = await waitForVideo(7000);
  if (vid) {
    try {
      vid.muted = false;
      vid.volume = 1.0;
      vid.currentTime = 0;
      await vid.play();
    } catch (e) {
      console.error('[FG] error play video:', e);
    }
  }

  // 6) tampilkan panel durasi & scroll acak
  showFullPanel(menit, 2 + Math.floor(Math.random() * 2));

  // 7) tunggu durasi video selesai
  console.log(`[FG] Menunggu ${menit} menit...`);
  await sleep(menit * 60 * 1000);


// update status video
// ===== update status video =====
if (targetIdVideo) {
  try {
    const formData = new URLSearchParams({
      id: targetIdVideo,
      email: targetEmail || userEmail
    });

    const statusRes = await fetch('https://bangnopi.id/api_youtube/getUpdateData', {
      method: 'POST',
      headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
      body: new URLSearchParams({ id: targetIdVideo, email: targetEmail || userEmail })
    });

    const text = await statusRes.text();
    if (statusRes.ok) console.log('[FG] Update video selesai OK:', text);
    else console.warn('[FG] Server reject updateStatus:', statusRes.status, text);

  } catch (e) {
    console.error('[FG] Gagal update status video:', e);
  }
}





  // 9) log selesai
  console.log('[FG] selesai nonton');
}









function waitForPath(fragment) {
  return new Promise((resolve) => {
    const t = setInterval(() => {
      if (location.pathname.includes(fragment)) {
        clearInterval(t);
        resolve(true);
      }
    }, 400);
  });
}

async function typeAndSearch(inputEl, text) {
  console.log('[FG] Mulai mengetik di search box...');
  inputEl.focus();
  inputEl.value = '';
  inputEl.dispatchEvent(new Event('input', { bubbles: true }));

  for (let i = 0; i <= text.length; i++) {
    inputEl.value = text.substring(0, i);
    inputEl.dispatchEvent(new Event('input', { bubbles: true }));
    await sleep(100 + Math.random() * 100);
  }

  console.log('[FG] Tekan Enter untuk cari video...');
  inputEl.dispatchEvent(
    new KeyboardEvent('keydown', { key: 'Enter', code: 'Enter', keyCode: 13, which: 13, bubbles: true })
  );
  inputEl.dispatchEvent(
    new KeyboardEvent('keyup', { key: 'Enter', code: 'Enter', keyCode: 13, which: 13, bubbles: true })
  );

  // tunggu beberapa detik untuk transisi hasil
  await sleep(2000);

  // fallback: kalau belum pindah ke /results, pakai window.location
  if (!location.pathname.includes('/results')) {
    console.warn('[FG] Fallback: belum pindah ke /results, pakai location.href manual');
    location.href = `https://www.youtube.com/results?search_query=${encodeURIComponent(text)}`;
  }

  // tunggu sampai benar-benar di halaman hasil
  await waitForPath('/results');
  console.log('[FG] Sudah di halaman hasil pencarian.');
}


async function findVideoInResults(keyword, maxScrolls = 12, delayMs = 700) {
  keyword = (keyword || '').toLowerCase().trim();
  for (let attempt = 0; attempt < maxScrolls; attempt++) {
    const candidates = Array.from(document.querySelectorAll('a#video-title, a.yt-simple-endpoint.style-scope.ytd-video-renderer'));
    for (const a of candidates) {
      const title = (a.textContent || '').trim().toLowerCase();
      if (title && title.includes(keyword)) {
        console.log('[FG] candidate match:', title);
        return a;
      }
    }
    // scroll down progressively
    window.scrollBy({ top: window.innerHeight * 0.8, left: 0, behavior: 'smooth' });
    await sleep(delayMs + Math.random() * 300);
  }
  return null;
}




async function showFullPanel(targetMenit = 1, scrollTimes = 2) {
  const vid = document.querySelector('video');
  if (!vid) return console.warn('[FG] Video tidak ditemukan');

  vid.currentTime = 0;
  vid.muted = false;
  vid.play().catch(e=>console.warn('[FG] Video play error', e));

  // overlay
  const overlay = document.createElement('div');
  overlay.id = 'vinet-overlay';
  overlay.style = `
    position:fixed;top:0;left:0;width:100%;height:100%;
    background:rgba(255,255,255,0.05);z-index:900;
    pointer-events:auto;cursor:not-allowed;`;
  document.body.appendChild(overlay);

  // tunggu sidebar
  let rightCol = await waitFor('ytd-watch-flexy #secondary', 15000);

  // buat panel
  const panel = document.createElement('div');
  panel.id = 'vinet-panel';
  if (rightCol) rightCol.insertAdjacentElement('afterbegin', panel);
  else document.body.appendChild(panel);


/*
panel.innerHTML = await (await fetch('https://bangnopi.id/api_youtube/getvideoplay', {
  method:'POST', body:new FormData(Object.assign(document.createElement('form'),{email:'user@example.com'}))
})).text();
*/



  // fetch konten panel
  try {
    const res = await fetch('https://bangnopi.id/api_youtube/getPanelShow');
    const html = await res.text();
    panel.innerHTML = html;

    // ======= semua parameter HARUS disini =======
    const vidTitleEl = panel.querySelector('#vidTitle');
    const vidDurationEl = panel.querySelector('#vidDuration');
    const timerEl = panel.querySelector('#timer');
    const stsEl = panel.querySelector('#sts');
    const currentTimeEl = panel.querySelector('#currentTime');
    const currentDateEl = panel.querySelector('#currentDate');
    const coinRewardEl = panel.querySelector('#coinReward');
	
	
if (coinRewardEl) coinRewardEl.textContent = targetCoin;
	
    // judul
    let rawTitle = document.title || '';
    let cleanTitle = rawTitle.replace(/\(\d+\)/g,'');
    if (vidTitleEl) vidTitleEl.textContent = cleanTitle;

    // tanggal & jam realtime
    const updateTime = () => {
      const now = new Date();
      if (currentDateEl) currentDateEl.textContent = `${String(now.getDate()).padStart(2,'0')}/${String(now.getMonth()+1).padStart(2,'0')}/${now.getFullYear()}`;
      if (currentTimeEl) currentTimeEl.textContent = `${String(now.getHours()).padStart(2,'0')}:${String(now.getMinutes()).padStart(2,'0')}`;
    };
    updateTime();
    setInterval(updateTime,1000);

    // durasi
    let userDuration = targetMenit;
    const popupDuration = document.querySelector('#videoDurationPopup');
    if (popupDuration) {
      const text = popupDuration.textContent.trim();
      if (/^\d{1,2}:\d{2}$/.test(text)) userDuration = text;
      else userDuration = `${String(text).padStart(2,'0')}:00`;
    } else userDuration = `${String(targetMenit).padStart(2,'0')}:00`;
    if (vidDurationEl) vidDurationEl.textContent = userDuration;

    // countdown timer
    let totalSeconds = typeof targetMenit==='number'?targetMenit*60:(()=>{
      const parts = userDuration.split(':');
      return parseInt(parts[0])*60 + parseInt(parts[1]);
    })();

    const tick = setInterval(()=>{
      if (!document.body.contains(panel)){ clearInterval(tick); return; }
      totalSeconds--;
      if (timerEl) timerEl.textContent = `${String(Math.floor(totalSeconds/60)).padStart(2,'0')}:${String(totalSeconds%60).padStart(2,'0')}`;
      if (vid.paused) vid.play().catch(()=>{});
      if (totalSeconds<=0){
        clearInterval(tick);
        if (stsEl) stsEl.textContent='Selesai';
        setTimeout(()=>location.href='https://www.youtube.com',2000);
      }
    },1000);

    // slide promo
    const adDiv = panel.querySelector('#adSlide .adText');
    if(adDiv){
      const promos = ["🚀 Boost viewers","🎬 More likes & subs","📈 Engagement naik cepat","🔥 Channel viral","💡 Fokus konten"];
      let current=0;
      setInterval(()=>{
        adDiv.style.opacity=0;
        setTimeout(()=>{
          current=(current+1)%promos.length;
          adDiv.textContent=promos[current];
          adDiv.style.opacity=1;
        },500);
      },3000);
    }

  } catch(e){ console.error('[FG] Error loading panel',e); }














  // scroll
  await sleep(50000);
  await humanScrollCommentStyle(3);
  await humanScrollFullOrganic(3);
  await randomScrollDuring(targetMenit, scrollTimes);
}






/**
 * Fungsi ini melakukan scroll random ke atas/bawah selama durasi tertentu
 * @param {number} minutes - lama scroll dalam menit
 * @param {number} times - jumlah scroll per siklus sebelum idle
 */
 
 
 
 
 // ---------- Scroll seperti manusia ----------
 // fungsi scroll human-like
  // ---------- Scroll organik random ----------
 async function humanScrollFullOrganic(repeat = 3) {
  const body = document.scrollingElement || document.body;
  const startPos = window.scrollY; // posisi awal sebelum scroll
  const maxScroll = body.scrollHeight - window.innerHeight;
  let count = 0;

  function scrollCycle() {
    if (count >= repeat) {
      // kembalikan ke posisi awal
      body.scrollTo({ top: startPos, behavior: 'smooth' });
      return;
    }

    // buat array langkah random untuk satu cycle
    const steps = [];
    const stepCount = 12 + Math.floor(Math.random() * 6); // 12-17 langkah
    for (let i = 0; i < stepCount; i++) {
      const rand = (Math.random() * 500) - 250; // ±250px
      steps.push(rand);
    }

    let i = 0;
    const stepInterval = setInterval(() => {
      let nextPos = body.scrollTop + steps[i];

      // batasi supaya tidak melewati batas bawah atau atas
      if (nextPos < 0) nextPos = 0;
      if (nextPos > maxScroll) nextPos = maxScroll;

      body.scrollTo({ top: nextPos, behavior: 'smooth' });
      i++;
      if (i >= steps.length) {
        clearInterval(stepInterval);
        count++;
        setTimeout(scrollCycle, 400 + Math.random() * 400); // delay acak sebelum cycle berikutnya
      }
    }, 200 + Math.random() * 200);
  }

  scrollCycle();
}
 
 
 
 
 
 
 
 
 
async function humanScrollCommentStyle(repeat = 5) {
  const totalHeight = document.body.scrollHeight - window.innerHeight;

  for (let r = 0; r < repeat; r++) {
    // scroll pendek ke bawah
    let steps = Math.floor(Math.random() * 5 + 3); // 3–7 langkah
    for (let i = 0; i < steps; i++) {
      const pos = Math.min(totalHeight, window.scrollY + (50 + Math.random() * 100)); // scroll 50–150px
      window.scrollTo({ top: pos, behavior: 'smooth' });
      await sleep(400 + Math.random() * 400); // jeda acak
    }

    // scroll pendek ke atas (sesekali)
    if (Math.random() > 0.3) {
      steps = Math.floor(Math.random() * 3 + 2); // 2–4 langkah
      for (let i = 0; i < steps; i++) {
        const pos = Math.max(0, window.scrollY - (30 + Math.random() * 80)); // scroll 30–110px
        window.scrollTo({ top: pos, behavior: 'smooth' });
        await sleep(300 + Math.random() * 300);
      }
    }

    // idle sebentar, kayak berhenti baca komentar
    await sleep(800 + Math.random() * 1000);
  }

  // ---------- KEMBALI KE ATAS MENTOK ----------
  window.scrollTo({ top: 0, behavior: 'smooth' });
}

/**
 * Fungsi ini melakukan scroll random ke atas/bawah selama durasi tertentu
 * @param {number} minutes - lama scroll dalam menit
 * @param {number} times - jumlah scroll per siklus sebelum idle
 */
async function randomScrollDuring(minutes, scrollTimes = 1, initialWatch = 50000) {
  const totalSec = minutes * 60;
  const scrollStartSec = Math.floor(totalSec * 0.5); // detik scroll awal
  let elapsed = 0;

  console.log(`[FG] Menonton video ${minutes} menit, scroll awal di detik ke ${scrollStartSec}...`);

  // Fungsi helper untuk timer countdown
  const updateTimer = (sec) => {
    const remaining = totalSec - sec;
    const m = String(Math.floor(remaining / 60)).padStart(2, '0');
    const s = String(remaining % 60).padStart(2, '0');
    console.log(`Countdown: ${m}:${s}`);
  };

  // ----- Interval setiap detik -----
  const ticker = setInterval(async () => {
    updateTimer(elapsed);

    // SCROLL AWAL pas waktu scrollStartSec
    if (elapsed === scrollStartSec) {
      console.log('[FG] Scroll awal turun 50-70% halaman lalu naik ke atas mentok...');
      for (let i = 0; i < scrollTimes; i++) {
        const pageHeight = document.body.scrollHeight - window.innerHeight;
        const downAmount = pageHeight * (0.5 + Math.random() * 0.2); // 50-70%
        window.scrollBy({ top: downAmount, left: 0, behavior: 'smooth' });
        await sleep(500 + Math.random() * 300);

        window.scrollTo({ top: 0, left: 0, behavior: 'smooth' });
        await sleep(500 + Math.random() * 300);
      }
    }

    elapsed++;
    if (elapsed > totalSec) {
      clearInterval(ticker);
      updateTimer(totalSec);
      console.log('[FG] randomScrollDuring selesai');
    }
  }, 1000);
}
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 

 
 
 

 
 
 
 
 /*
async function randomScrollDuring(minutes, scrollTimes = 1, initialWatch = 50000) {
  // ---------- SCROLL DI DETIK PERTAMA ----------
  console.log('[FG] Scroll detik pertama...');
  for (let i = 0; i < scrollTimes; i++) {
    const atTop = window.scrollY <= 0;
    const atBottom = (window.innerHeight + window.scrollY) >= document.body.scrollHeight;
    let dir;
    if (atTop) dir = 1;
    else if (atBottom) dir = -1;
    else dir = Math.random() > 0.5 ? 1 : -1;

    const amount = 50 + Math.random() * 100; // scroll pendek, kayak baca komentar
    window.scrollBy({ top: dir * amount, left: 0, behavior: 'smooth' });
    await sleep(300 + Math.random() * 300);
  }

  // ---------- JEDA TONTON ----------
  console.log(`[FG] Menunggu ${initialWatch / 1000}s sebelum scroll rutin...`);
  await sleep(initialWatch);

  // ---------- SCROLL SELAMA WAKTU ----------
  const totalMs = minutes * 60 * 1000;
  const end = Date.now() + totalMs;
  let done = 0;

  while (Date.now() < end) {
    if (done < scrollTimes) {
      const atTop = window.scrollY <= 0;
      const atBottom = (window.innerHeight + window.scrollY) >= document.body.scrollHeight;
      let dir;
      if (atTop) dir = 1;
      else if (atBottom) dir = -1;
      else dir = Math.random() > 0.5 ? 1 : -1; // naik-turun acak

      const amount = 50 + Math.random() * 120; // scroll pendek-medium
      window.scrollBy({ top: dir * amount, left: 0, behavior: 'smooth' });

      done++;
      await sleep(400 + Math.random() * 400);
    } else {
      await sleep(800 + Math.random() * 500);
      done = 0;
    }
  }

  // ---------- SCROLL DI AKHIR (MENTOK ATAS) ----------
  console.log('[FG] Scroll akhir sebelum selesai...');
  const steps = 5; // jumlah langkah scroll akhir
  for (let i = 0; i < steps; i++) {
    const pos = window.scrollY - (window.scrollY / (steps - i)); // gradual naik ke atas
    window.scrollTo({ top: pos, left: 0, behavior: 'smooth' });
    await sleep(200 + Math.random() * 200);
  }
  window.scrollTo({ top: 0, left: 0, behavior: 'smooth' }); // pastikan mentok atas

  console.log('[FG] randomScrollDuring selesai');
}
*/









/**
 * Tunggu sampai elemen muncul di DOM
 * @param {string} selector - querySelector
 * @param {number} timeout - max waktu tunggu (ms)
 * @returns {Promise<HTMLElement|null>}
 */
// helper tunggu elemen
async function waitFor(selector, timeout = 3000) {
  const start = Date.now();
  while (Date.now() - start < timeout) {
    const el = document.querySelector(selector);
    if (el) return el;
    await new Promise(r => setTimeout(r, 50));
  }
  return null;
}

// panggil setelah panel.innerHTML selesai




function removePanel() {
  document.getElementById('bangnopi-panel')?.remove();
}

function waitForVideo(timeout = 5000) {
  return new Promise((resolve) => {
    const end = Date.now() + timeout;
    const iv = setInterval(() => {
      const v = document.querySelector('video');
      if (v) {
        clearInterval(iv);
        resolve(v);
      } else if (Date.now() > end) {
        clearInterval(iv);
        resolve(null);
      }
    }, 300);
  });
}


function showPanel(minutes) {
  removePanel();
  const panel = document.createElement('div');
  panel.id = 'bangnopi-panel';
  panel.style = 'position:fixed;bottom:20px;left:20px;background:#111;color:#0f0;padding:10px 12px;border-radius:6px;z-index:999999;font-family:monospace;font-size:14px';
  const span = document.createElement('span');
  span.id = 'bnp-countdown';
  panel.innerHTML = `⏳ Sisa: <span id="bnp-countdown">00:00</span>`;
  document.body.appendChild(panel);

  // start countdown
  let total = minutes * 60;
  const t = setInterval(() => {
    if (total <= 0) { clearInterval(t); return; }
    total--;
    const mm = String(Math.floor(total / 60)).padStart(2, '0');
    const ss = String(total % 60).padStart(2, '0');
    const el = document.getElementById('bnp-countdown');
    if (el) el.textContent = `${mm}:${ss}`;
  }, 1000);
  panel.dataset.timerId = 'running';
}






