console.log('[BG] Service worker started');

let _judul = '';
let _menit = 1;
let tabIdActivStart = 0;

function safeSendToTab(tabId, message) {
  return new Promise((resolve) => {
    chrome.tabs.sendMessage(tabId, message, (resp) => {
      if (chrome.runtime.lastError) resolve({ ok: false });
      else resolve({ ok: true, resp });
    });
  });
}

// ====================
// MESSAGE LISTENER
// ====================
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {

  if (request.action === 'getUserEmail') {
    if (chrome.identity?.getProfileUserInfo) {
      chrome.identity.getProfileUserInfo((info) => sendResponse({ email: info?.email || 'guest@chrome' }));
    } else sendResponse({ email: 'guest@chrome' });
    return true;
  }

  if (request.action === 'fetchFromAPI') {
    fetch(request.url, {
      method: request.method || 'GET',
      headers: request.headers || {},
      body: request.body || null
    })
      .then(res => res.text())
      .then(text => sendResponse({ ok: true, text }))
      .catch(() => sendResponse({ ok: false }));
    return true;
  }

  if (request.message === 'startApp') {
    _judul = request.judul || '';
    _menit = request.menit || 1;

    chrome.tabs.query({ url: '*://www.youtube.com/*' }, async (tabs) => {
      let tab = tabs[0];
      if (!tab) {
        tab = await chrome.tabs.create({ url: 'https://www.youtube.com', active: true });
        setTimeout(async () => {
          await chrome.scripting.executeScript({ target: { tabId: tab.id }, files: ['js/foreground.js'] });
          await safeSendToTab(tab.id, { message: 'startApp', judul: _judul, menit: _menit });
        }, 2000);
      } else {
        const res = await safeSendToTab(tab.id, { message: 'startApp', judul: _judul, menit: _menit });
        if (!res.ok) {
          await chrome.scripting.executeScript({ target: { tabId: tab.id }, files: ['js/foreground.js'] });
          setTimeout(async () => {
            await safeSendToTab(tab.id, { message: 'startApp', judul: _judul, menit: _menit });
          }, 800);
        }
      }
      tabIdActivStart = tab.id;
    });

    sendResponse(true);
    return true;
  }

  if (request.message === 'DataVideo') {
    sendResponse({ stsVid: !!_judul, judul: _judul, menit: _menit });
    return true;
  }

  sendResponse({ ok: true });
  return true;
});

// ====================
// KEEP ALIVE (silent)
// ====================
setInterval(() => {
  try { chrome.runtime.getPlatformInfo(() => {}); } catch {}
}, 30000);
